<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});





Route::get('/car/{slug}', function ($slug) {

    $car = DB::table('cars')
        ->join('car_brands', 'cars.brand_id', '=', 'car_brands.id')
        ->join('car_models', 'cars.model_id', '=', 'car_models.id')
        ->where('cars.slug', $slug)
        ->where('cars.status', 'Available')
        ->select(
            'cars.slug',
            'cars.description',
            'cars.year',
            'car_brands.name as brand',
            'car_models.name as model',
            DB::raw('(
                    SELECT car_images.image_path
                    FROM car_images
                    WHERE car_images.car_id = cars.id
                    ORDER BY car_images.id ASC
                    LIMIT 1
                ) as cover_image')
        )
        ->first();

    if (!$car) {
        abort(404);
    }

    return view('og.car', [
        'title' => $car->slug,
        'description' => $car->description,
        'brand' => $car->brand,
        'model' => $car->model,
        'year' => $car->year,
        'image' => $car->cover_image,
        'slug' => $slug
    ]);
});

Route::get('/brand/{slug}', function ($slug) {

    $brand = DB::table('brands')
        ->where('slug', $slug)
        ->select('name', 'description', 'logo')
        ->first();

    if (!$brand) {
        abort(404);
    }

    return view('og.brand', [
        'title' => $brand->name . ' Cars for Sale',
        'image' => $brand->logo,
        'slug' => $slug
    ]);
});

Route::get('/sitemap.xml', function () {

    $cars = DB::table('cars')
        ->where('status', 'Available')
        ->select('slug', 'updated_at')
        ->get();

    return response()
        ->view('sitemap.cars', compact('cars'))
        ->header('Content-Type', 'application/xml');
});


// Route::get('/sitemap.xml', function () {

//     $cars = DB::table('cars')
//         ->where('status', 'Available')
//         ->where('featured', 1)
//         ->select('slug', 'updated_at')
//         ->orderBy('updated_at', 'desc')
//         ->get();

//     return response()
//         ->view('sitemap', compact('cars'))
//         ->header('Content-Type', 'application/xml');
// });



// Route::get('/car/{slug}', function ($slug) {

//     $userAgent = request()->header('User-Agent');
//     $isBot = preg_match('/facebookexternalhit|twitterbot|linkedinbot|whatsapp/i', $userAgent);

//     // Serve OG HTML for social bots
//     if ($isBot) {
//         $car = DB::table('cars')->where('slug', $slug)->first();
//         abort_if(!$car, 404);

//         return view('car-og', compact('car'));
//     }

//     // Only redirect if we are NOT already on the frontend domain
//     $frontendDomain = parse_url(config('app.frontend_url'), PHP_URL_HOST);
//     $currentHost = request()->getHost();

//     if ($currentHost !== $frontendDomain) {
//         return redirect()->away(config('app.frontend_url') . "/car/$slug");
//     }

//     // Otherwise, do nothing to avoid loop
//     return 'React app should load here'; // just a placeholder in dev
// });
