<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendCodeResetPassword extends Mailable
{
    use Queueable, SerializesModels;

    public $token;

    /**
     * Create a new message instance.
     */
    public function __construct($token)
    {
        $this->token = $token;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->from('advert@cbtplus.com.ng', 'CBTplus')
            ->subject('Reset Your Password')
            ->view('emails.reset-password')
            ->with([
                'token' => $this->token,
            ]);
    }
}
