<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;

class PageController extends Controller
{
    public function index()
    {
        $data = DB::table('pages')->get();

        return $this->sendResponse(['data' => $data], 'Pages retrieved', 200);
    }

    public function show($slug)
    {
        $page = DB::table('pages')->where('slug', $slug)->first();

        if (!$page) {
            return $this->sendError('Page not found', 'Not Found', 404);
        }

        return $this->sendResponse(['data' => $page], 'Page retrieved', 200);
    }
}
