<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\DB;
use Tymon\JWTAuth\Facades\JWTAuth;

class Controller extends BaseController
{
    use AuthorizesRequests;
    use DispatchesJobs;
    use ValidatesRequests;

    public function sendResponse($data, $message, $status = 200)
    {
        $response = [
            'data' => $data,
            'message' => $message,
        ];

        return response()->json($response, $status);
    }

    public function sendError($errorData, $message, $status = 500)
    {
        $response = [];
        $response['message'] = $message;
        if (! empty($errorData)) {
            $response['data'] = $errorData;
        }

        return response()->json($response, $status);
    }

    protected function JWTAuth()
    {
        $user = JWTAuth::parseToken()->authenticate();

        return $user;
    }

    public function checkJWTAuth()
    {
        try {
            $token = JWTAuth::getToken();
            JWTAuth::checkOrFail($token);
        } catch (\Tymon\JWTAuth\Exceptions\TokenExpiredException $e) {
            return false;
        } catch (\Tymon\JWTAuth\Exceptions\JWTException $e) {
            return false;
        }

        return true;
    }

    public static function generateCode($tbl, $col)
    {
        $code = rand(111, 999).rand(111, 999);

        $checkCode = DB::table($tbl)
            ->where($col, $code)
            ->first();
        if ($checkCode) {
            return $tbl === 'avail_exams' ? 'EX'.$code + 1 : $code + 1;
        } else {
            return $tbl === 'avail_exams' ? 'EX'.$code : $code;
        }
    }
}
